	.INCLUDE	"global.inc"
	.IMPORT	MUL8
	.IMPORT	PLAYER, MAPUPDT, ACTORS, OBJECTS
	.IMPORT	GCINIT, GCREAD
	.IMPORT	SCREENFILL
	.IMPORT	RENDER
	.IMPORT	SFXPLAY, SFXUPDT
	.IMPORT	DIV8
	.EXPORT	TEXPAGEUPDT
	.EXPORT	RENDERSTATUS, RENDERPAGE
	.EXPORT	OBJDBTYPE, OBJDBXPOS, OBJDBYPOS, OBJSTATE
	.EXPORT	FPS, PREVBTTNS
;
; MEMORY AREAS USED FOR STORAGE.
;
ZPIMG	=	$0200	;SAVED ZERO PAGE
	
	.CODE

;**************************************
;*
;* ESCAPE ENGINE
;* 
;* COPYRIGHT 2007, DAVID SCHMENK
;*
;**************************************

	JMP	INIT
BREAKPOINT:	RTS
	
	.BYTE	"COPYRIGHT 2007, DAVID SCHMENK"

INIT:	JSR	ZPSAVE
	LDA	LVLBASE	;EXTRACT BASE ADDRESS FOR MAPS
	STA	LVLPTR
	STA	LVLMAPBASE
	LDA	LVLBASE+1
	STA	LVLPTR+1
	CLC		;OFFSET INTO WALL MAP
	ADC	#$04
	STA	LVLMAPBASE+1
	LDX	#$00	;EXTRACT MAP DIMENSION
	LDY	#$00	;CALC SHIFT COUNT FOR ROW ADDR
	LDA	(LVLPTR),Y
	STA	MAPWDTH
	BNE	WID2SFT
	LDA	#$FE
	STA	RETCODE
	JMP	RETURN	;CAN'T HAVE ZERO WIDTH MAP
WID2SFT:	INX
	LSR
	BNE	WID2SFT
	DEX
	STX	MAPSHFT
	LDA	#$80	;EXTRACT PLAYER START POS/DIR
	STA	PLAYERX
	STA	PLAYERY
	LDY	#$01
	LDA	(LVLPTR),Y
	STA	PLAYERX+1
	INY
	LDA	(LVLPTR),Y
	STA	PLAYERY+1
	INY
	LDA	(LVLPTR),Y
	STA	PLAYERA
	LDA	LVLPTR	;COPY OBJECT DATABASE TO LOCAL ARRAY
	CLC
	ADC	#$04
	STA	OBJPTR
	LDA	LVLPTR+1
	ADC	#$00
	STA	OBJPTR+1
	LDX	#$00
OBJDBCOPY:	LDY	#$00
	LDA	(OBJPTR),Y	;GET OBJECT TYPE
	STA	OBJDBTYPE,X
	INY
	LDA	(OBJPTR),Y	;GET OBJECT X COORD
	STA	OBJDBXPOS,X
	INY
	LDA	(OBJPTR),Y	;GET OBJECT Y COORD
	STA	OBJDBYPOS,X
	LDA	#$00
	STA	OBJSTATE,X
	LDA	OBJPTR
	CLC
	ADC	#$04
	STA	OBJPTR
	LDA	OBJPTR+1
	ADC	#$00
	STA	OBJPTR+1
	INX
	CPX	#MAXOBJECTS
	BNE	OBJDBCOPY
	LDA	MAPWDTH	;MAP DIMENSION
	TAX
	JSR	MUL8
	TAY
	TXA
	CLC
	ADC	LVLMAPBASE	;OFFSET INTO TEX PAGE MAP
	STA	LVLTPGBASE
	TYA
	ADC	LVLMAPBASE+1
	STA	LVLTPGBASE+1
	LDA	LVLPTR	;STICK OBJECT MAP OVER
	STA	LVLOBJBASE	;OBJECT DATABASE UNLESS
	LDA	LVLPTR+1	;IT IS BIGGER THAN 32X32
	STA	LVLOBJBASE+1
	LDA	MAPWDTH	;MAP DIMENSION
	CMP	#64
	BCC	IMGOFFSETS
	TAX
	JSR	MUL8
	TAY
	TXA
	CLC
	ADC	LVLTPGBASE	;OFFSET INTO OBJECT MAP
	STA	LVLOBJBASE
	TYA
	ADC	LVLTPGBASE+1
	STA	LVLOBJBASE+1
IMGOFFSETS:	LDA	IMGBASE	;TEXTURE PAGES
	STA	TEXBASE
	STA	SPRTBASE
	STA	TEXPTR
	LDA	IMGBASE+1
	STA	TEXPTR+1
	LDY	#$01
	LDA	(TEXPTR),Y	;SPRITE BASE OFFSET
	CLC
	ADC	TEXPTR+1
	STA	SPRTBASE+1
	INY
TPGCOPY:	LDA	(TEXPTR),Y	;COPY TEX PAGE INFO TO LOCAL ARRAY
	STA	TEXPGOFFSET-2,Y
	INY
	CPY	#$31
	BNE	TPGCOPY
	LDA	LVLOBJBASE
	STA	OBJPTR
	LDA	LVLOBJBASE+1
	STA	OBJPTR+1
	LDX	MAPWDTH
	LDY	MAPWDTH
	LDA	#$00
OBJMAPCLEAR:	DEY
	STA	(OBJPTR),Y
	BNE	OBJMAPCLEAR
	LDA	MAPWDTH
	TAY
	CLC
	ADC	OBJPTR
	STA	OBJPTR
	LDA	#$00
	ADC	OBJPTR+1
	STA	OBJPTR+1
	LDA	#$00
	DEX
	BNE	OBJMAPCLEAR
	LDX	#$00
OBJMAPFILL:	LDA	OBJDBTYPE,X	;GET OBJECT TYPE
	BEQ	OBJFILLNEXT	;EMPTY, SKIP
	LDA	OBJDBYPOS,X	;GET OBJECT Y COORD
	STX	ODBCUR
	LDX	MAPWDTH
	JSR	MUL8
	PHA
	TXA
	CLC
	ADC	LVLOBJBASE
	STA	OBJPTR
	PLA
	ADC	LVLOBJBASE+1
	STA	OBJPTR+1
	LDX	ODBCUR
	LDA	OBJDBXPOS,X	;GET OBJECT X COORD
	TAY
	LDA	OBJDBTYPE,X	;SAVE SPRITE INDEX
	STA	(OBJPTR),Y
OBJFILLNEXT:	INX
	CPX	#MAXOBJECTS
	BNE	OBJMAPFILL
INITFLAGS:	LDA	#$01
	STA	ODBCUR	;INIT TO 1
	STA	JOYSTICK	;ENABLE JOYSTICK BY DEFAULT
	LDX	RENDERSTATUS
	LDA	DISPFUL,X	;FULL SCREEN MODE/MIX MODE
	LDA	GRLORES	;LORES GRAPHICS MODE
	LDA	DISPGR	;GRAPHICS MODE
	LDA	DISPPG1	;FIRST PAGE
	JSR	STATUSINIT
	LDA	#$00
	STA	TONE
	STA	GCBTTNS
	LDY	#SFXPOWERUP
	JSR	SFXPLAY
	JSR	MAPUPDT	;INIT MAP PTRS
	JSR	GCINIT	;INIT GAMECONTROLLERS
	LDA	CNTRX
	CMP	#56
	BCC	MAINLOOP
	LDA	CNTRY
	CMP	#56
	BCC	MAINLOOP
	LDA	#$00
	STA	JOYSTICK
	LDA	#32
	STA	CNTRX
	STA	CNTRY
;
; MAIN LOOP
;
MAINLOOP:	LDA	GCBTTNS
	STA	PREVBTTNS
	JSR	SFXUPDT
	JSR	GCREAD
	LDA	JOYSTICK
	BNE	CHKBTTNS
	LDA	CNTRX
	STA	GCXPOS
	LDA	CNTRY
	STA	GCYPOS
	LDA	#$00
	STA	GCBTTNS
CHKBTTNS:	LDA	GCBTTNS
	AND	#GCBTTN1
	BEQ	CHKKB
	EOR	PREVBTTNS
	AND	#GCBTTN1
	BEQ	CHKKB
	JMP	OPENDOOR
CHKKB:	LDA	KBHIT
	BPL	UPDATE
	JMP	KEYPRESS
UPDATE:	JSR	ACTORS	;UPDATE ACTORS
	JSR	PLAYER	;UPDATE PLAYER
	JSR	OBJECTS
	LDA	RENDERPAGE	;UPDATE RENDER BUFFER
	EOR	#$01
	STA	RENDERPAGE
	JSR	RENDER
	LDX	RENDERPAGE
	LDA	DISPPAGE,X	;DISPLAY NEW BUFFER
	DEC	FRAMECNT	;UPDATE TIME
	BNE	MAINLOOP
	LDA	TPGMASK
	EOR	#$FF
	STA	TPGMASK
	JSR	TEXPAGEUPDT
	LDA	FPS
	STA	FRAMECNT
	DEC	FRACSECOND
	BNE	MAINLOOP
	LDX	#$02
	STX	FRACSECOND
	LDX	SECONDS
	INX
	STX	SECONDS
	CPX	#60
	BCC	CHKSTATUS
	LDX	#$00
	STX	SECONDS
	LDX	MINUTES
	INX
	STX	MINUTES
	CPX	#60
	BCC	CHKSTATUS
	LDX	#$00
	STX	MINUTES
	LDX	HOURS
	INX
	STX	HOURS
CHKSTATUS:	JSR	STATUSUPDT
	LDA	ENERGY+1
	BMI	EXHAUSTED	
	LDA	DOORCLOSEMAP
	BEQ	JMPLOOP
	DEC	DOORCLOSEDELAY
	BNE	JMPLOOP
	JSR	CLOSEDOOR
JMPLOOP:	JMP	MAINLOOP
;
; OUT OF ENERGY.
;
EXHAUSTED:	LDA	#$01
	STA	RETCODE
	JMP	RETURN
;
; CLOSE DOOR IN MAP
;
CLOSEDOOR:	LDX	DOORCLOSEPTR
	STX	MAPPTR
	LDX	DOORCLOSEPTR+1
	STX	MAPPTR+1
	LDY	DOORCLOSEX
	LDA	DOORCLOSEMAP
	STA	(MAPPTR),Y
	LDA	#$00
	STA	DOORCLOSEMAP
	LDY	#SFXDOORCLOSE
	JSR	SFXPLAY
	RTS	
;
; EXIT LEVEL
;
EXITLEVEL:	LDA	#$00
	STA	RETCODE
	JMP	RETURN
;
; OPEN DOOR IN MAP
;
OPENDOOR:	LDA	AHEADDST+1
	CMP	#$02
	BCC	CHKDOOR
	JMP	CHKKB	;TOO FAR AWAY
CHKDOOR:	LDA	AHEADOBJ
	CMP	#$10	;LOOK FOR DOOR
	BEQ	OPENITSHR
	CMP	#$01
	BEQ	OPENITSHL
	CMP	#$F0	;EXIT DOOR
	BEQ	EXITLEVEL
	CMP	#$0F
	BEQ	EXITLEVEL
	JMP	CHKKB	;NOT DOOR
OPENITSHR:	LSR
	LSR
	LSR
	LSR
	BNE	OPENIT
OPENITSHL:	ASL
	ASL
	ASL
	ASL
OPENIT:	LDX	DOORCLOSEMAP	;LOOK FOR ALREADY OPEN DOOR
	BEQ	CLOSED
	PHA
	JSR	CLOSEDOOR	;CLOSE OPEN DOOR FIRST
	PLA
	LDX	DOORCLOSEPTR
	CPX	AHEADPTR
	BNE	CLOSED
	LDX	DOORCLOSEPTR+1
	CPX	AHEADPTR+1
	BNE	CLOSED
	LDA	#0
	BEQ	OPENED
CLOSED:	LDY	AHEADX+1
	STY	DOORCLOSEX
	LDX	AHEADPTR
	STX	DOORCLOSEPTR
	STX	MAPPTR
	LDX	AHEADPTR+1
	STX	DOORCLOSEPTR+1
	STX	MAPPTR+1
	PHA
	LDA	(MAPPTR),Y
	STA	DOORCLOSEMAP
	PLA
	STA	(MAPPTR),Y
	LDY	#SFXDOOROPEN
	JSR	SFXPLAY
	LDA	#DOORCLOSEWAIT
OPENED:	STA	DOORCLOSEDELAY
	JMP	CHKKB
;
; KEYPRESS HANDLER
;
KEYPRESS:	STA	KBSTROBE
	CMP	#$A0	;SPACEBAR
	BEQ	OPENDOOR
	CMP	#$D7	;'W' KEY
	BEQ	MVFORWARD
	CMP	#$8B	;UP ARROW
	BEQ	MVFORWARD
	CMP	#$D3	;'Z' KEY
	BEQ	MVBACKWRD
	CMP	#$8A	;DOWN ARROW
	BEQ	MVBACKWRD
	CMP	#$C1	;'A' KEY
	BEQ	SLDLT
	CMP	#$C4	;'D' KEY
	BEQ	SLDRT
	CMP	#$88	;LEFT ARROW
	BEQ	TURNLT
	CMP	#$95	;RIGHT ARROW
	BEQ	TURNRT
	CMP	#$D8	;'X' KEY
	BEQ	SPIN180
	CMP	#$D0	;'P' KEY
	BNE	KEYCHKJ
	JMP	TOGGLESTATUS
KEYCHKJ:	CMP	#$CA	;'J' KEY
	BNE	KEYCHKESC
	JMP	TOGGLEJOYSTK
KEYCHKESC:	CMP	#$9B	;ESC KEY
	BEQ	ESCEXIT
KBEXIT:	JMP	UPDATE
;
; ESCAPE OUT OF LEVEL
;
ESCEXIT:	LDA	GCBTTNS	;ONLY ESCAPE IF BUTTON DOWN
	BEQ	KBEXIT
	LDA	#$FF
	STA	RETCODE
	JMP	RETURN
;
; KEYBOARD MOVEMENT
;
MVFORWARD:	LDA	CNTRY
	LSR
	LSR
	STA	GCYPOS
	JMP	UPDATE
MVBACKWRD:	LDA	CNTRY
	ASL
	STA	GCYPOS
	JMP	UPDATE
SLDLT:	LDA	#GCBTTN2
	ORA	GCBTTNS
	STA	GCBTTNS
TURNLT:	LDA	CNTRX
	SEC
	SBC	#16+2
	STA	GCXPOS
	JMP	UPDATE
SLDRT:	LDA	#GCBTTN2
	ORA	GCBTTNS
	STA	GCBTTNS
TURNRT:	LDA	CNTRX
	CLC
	ADC	#16-2
	STA	GCXPOS
	JMP	UPDATE
SPIN180:	LDA	#$03
	STA	GCBTTNS
	JMP	UPDATE

;
; TOGGLE JOYSTICK INPUT
;
TOGGLEJOYSTK:	LDA	JOYSTICK
	BNE	TOGGLEJOYOFF
	JSR	GCINIT	;INIT GAMECONTROLLERS
	LDA	CNTRX
	CMP	#56
	BCC	TOGGLEJOYON
	LDA	CNTRY
	CMP	#56
	BCC	TOGGLEJOYON
TOGGLEJOYOFF:	LDA	#$00
	STA	JOYSTICK
	LDA	#32
	STA	CNTRX
	STA	CNTRY
	JMP	UPDATE
TOGGLEJOYON:	LDA	#$01
	STA	JOYSTICK
	JMP	UPDATE
;
; TOGGLE STATUS PANEL
;
TOGGLESTATUS:	LDA	RENDERSTATUS
	EOR	#$01
	STA	RENDERSTATUS
	TAX
	STA	DISPSPLIT,X
	BEQ	TOGGLESTATOFF
	JSR	STATUSINIT
	LDA	#MIXSCREENFPS
	STA	FPS
	STA	FRAMECNT
	LDA	#$02
	STA	FRACSECOND
	JMP	UPDATE
TOGGLESTATOFF:	LDA	#FULLSCREENFPS
	STA	FPS
	STA	FRAMECNT
	LDA	#0
	STA	VIEWCOLLEFT
	LDA	#40
	STA	VIEWCOLRIGHT
	JMP	UPDATE
;
; TEXTURE PAGE UPDATE
;
TEXPAGEUPDT:	LDY	PLAYERX+1
	LDA	(TPGROW),Y
	AND	TPGMASK
	CMP	#$10
	BCC	TPGCALC
	LSR
	LSR
	LSR
	LSR
TPGCALC:	TAY
	LDA	TEXPGOFFSET,Y
	CLC
	ADC	IMGBASE+1
	STA	TEXBASE+1
	LDA	TEXPGCLRCEIL,Y
	STA	CLRCEIL
	LDA	TEXPGCLRFLR,Y
	STA	CLRFLR
	RTS
;
; STATUS DISPLAY
;
STATUSINIT:	LDA	#MIXSCREENFPS
	STA	FPS
	STA	FRAMECNT
	LDA	#0
	STA	VIEWCOLLEFT
	LDA	#40
	STA	VIEWCOLRIGHT
	LDA	RENDERSTATUS
	PHA
	LDA	#$00
	STA	RENDERSTATUS
	LDA	#$00
	JSR	SCREENFILL
	PLA
	STA	RENDERSTATUS
	BNE	STATUSSETVIEW
	JMP	STATUSDONE
STATUSSETVIEW:	LDA	#4
	STA	VIEWCOLLEFT
	LDA	#36
	STA	VIEWCOLRIGHT
	LDX	#40
	LDA	#$A0
STATUSCLEAR:	DEX
	STA	$650,X
	STA	$A50,X
	STA	$6D0,X
	STA	$AD0,X
	STA	$750,X
	STA	$B50,X
	STA	$7D0,X
	STA	$BD0,X
	BEQ	STATUSTXT
	JMP	STATUSCLEAR
STATUSTXT:	LDA	STATUSCHARS,X
	BNE	STATUSCHAR
	JMP	STATUSDONE
STATUSCHAR:	ORA	#$80
	STA	$6D0+6,X
	STA	$AD0+6,X
	INX
	BNE	STATUSTXT
STATUSUPDT:	LDA	RENDERSTATUS
	BNE	STATUSVALS
	RTS
STATUSVALS:	LDA	LEVEL	;LEVEL #
	LDY	#7
	LDX	#10
	JSR	DIV8
	PHA
	INX
	LDA	LEVEL
	CMP	#10
	TXA
	SBC	#$00
	TAX
	LDA	DIGITSPC,X
	STA	$750,Y
	STA	$B50,Y
	PLA
	TAX
	LDA	DIGIT,X
	STA	$751,Y
	STA	$B51,Y
	LDY	#18
	LDA	ENERGY+1	;ENERGY LEVEL
	LDX	#100
	JSR	DIV8
	PHA
	INX
	LDA	ENERGY+1
	CMP	#100
	TXA
	SBC	#$00
	TAX
	LDA	DIGITSPC,X
	STA	$750,Y
	STA	$B50,Y
	PLA
	LDX	#10
	JSR	DIV8
	PHA
	INX
	LDA	ENERGY+1
	CMP	#10
	TXA
	SBC	#$00
	TAX
	LDA	DIGITSPC,X
	STA	$751,Y
	STA	$B51,Y
	PLA
	TAX
	LDA	DIGIT,X
	STA	$752,Y
	STA	$B52,Y
	LDA	#'%'|$80
	STA	$753,Y
	STA	$B53,Y
	LDA	HOURS	;TIME
	LDY	#26
	LDX	#10
	JSR	DIV8
	PHA
	LDA	DIGIT,X
	STA	$750,Y
	STA	$B50,Y
	PLA
	TAX
	LDA	DIGIT,X
	STA	$751,Y
	STA	$B51,Y
	LDA	#':'|$80
	STA	$752,Y
	STA	$B52,Y
	LDA	MINUTES
	LDX	#10
	JSR	DIV8
	PHA
	LDA	DIGIT,X
	STA	$753,Y
	STA	$B53,Y
	PLA
	TAX
	LDA	DIGIT,X
	STA	$754,Y
	STA	$B54,Y
	LDA	#':'|$80
	STA	$755,Y
	STA	$B55,Y
	LDA	SECONDS
	LDX	#10
	JSR	DIV8
	PHA
	LDA	DIGIT,X
	STA	$756,Y
	STA	$B56,Y
	PLA
	TAX
	LDA	DIGIT,X
	STA	$757,Y
	STA	$B57,Y
STATUSDONE:	RTS
;
; RETURN BACK TO BASIC AFTER RESTORING ZP AND TXTPG2
;
RETURN:	JSR	ZPRESTORE
	STA	DISPPG1
	STA	DISPTXT
	JSR	$FC58	;CLEAR SCREEN
	RTS		;RETURN TO BASIC
;
; ZERO PAGE SAVE AND RESTORE
;
ZPRESTORE:	LDX	#$00
ZPRESTORELOOP:	LDA	ZPIMG,X
	STA	$00,X
	INX
	BNE	ZPRESTORELOOP
	RTS
ZPSAVE:	LDX	#$00	;SAVE IMPORTANT MEMORY AREAS
ZPSAVELOOP:	LDA	$00,X
	STA	ZPIMG,X
	INX
	BNE	ZPSAVELOOP
	RTS
	
	.DATA
	
RENDERSTATUS:	.BYTE	1
RENDERPAGE:	.BYTE	0
STATUSCHARS:	.BYTE	"LEVEL      ENERGY     TIME", 0
DIGITSPC:	.BYTE	' '|$80
DIGIT:	.BYTE	'0'|$80, '1'|$80, '2'|$80, '3'|$80, '4'|$80
	.BYTE	'5'|$80, '6'|$80, '7'|$80, '8'|$80, '9'|$80
DOORCLOSEDELAY:	.BYTE	0
DOORCLOSEMAP:	.BYTE	0
DOORCLOSEX:	.BYTE	0
DOORCLOSEPTR:	.ADDR	0
TPGMASK:	.BYTE	$0F
FRACSECOND:	.BYTE	2
PREVINT:	.RES	2
PREVBTTNS:	.RES	1
FPS:	.RES	1
FRAMECNT:	.RES	1
TEXPGOFFSET:	.RES	16
TEXPGCLRCEIL:	.RES	16
TEXPGCLRFLR:	.RES	16
OBJDBTYPE:	.RES	MAXOBJECTS
OBJDBXPOS:	.RES	MAXOBJECTS
OBJDBYPOS:	.RES	MAXOBJECTS
OBJSTATE:	.RES	MAXOBJECTS